package ru.yandex.webmaster3.viewer.http.turbo.commerce;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.turbo.model.TurboHostSettings;
import ru.yandex.webmaster3.core.turbo.model.TurboHostSettings.TurboHostSettingsBuilder;
import ru.yandex.webmaster3.core.turbo.model.commerce.TurboCommerceInfoSection;
import ru.yandex.webmaster3.core.turbo.model.commerce.TurboCommerceSettings.TurboCommerceSettingsBuilder;
import ru.yandex.webmaster3.core.turbo.model.desktop.TurboDesktopSettings.TurboDesktopSettingsBuilder;
import ru.yandex.webmaster3.core.turbo.model.error.TurboErrorType;
import ru.yandex.webmaster3.core.turbo.model.error.TurboRawError;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboErrorInfo;
import ru.yandex.webmaster3.storage.turbo.service.preview.TurboFeedPreviewService;
import ru.yandex.webmaster3.storage.turbo.service.preview.TurboHostSettingsUploadResponse;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;
import ru.yandex.webmaster3.viewer.http.turbo.commerce.ValidateTurboCommerceInfoSectionAction.Request;
import ru.yandex.webmaster3.viewer.http.turbo.commerce.ValidateTurboCommerceInfoSectionAction.Response;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by Oleg Bazdyrev on 05/09/2018.
 * WMC-6334 - валидация содержимого инфо-блока для e-commerce
 */
@ReadAction
@Category("turbo")
@Description("Проверка текста информационного блока e-commerce (аккордеона)")
public class ValidateTurboCommerceInfoSectionAction extends AbstractUserVerifiedHostAction<Request, Response> {

    private TurboFeedPreviewService turboFeedPreviewService;

    @Override
    public Response process(Request request) {
        // делаем фиктивные настройки
        TurboCommerceInfoSection section = new TurboCommerceInfoSection("title", request.getValue());
        TurboHostSettings fakeSettings = new TurboHostSettingsBuilder().setCommerceSettings(
                new TurboCommerceSettingsBuilder().setInfoSections(Collections.singletonList(section)).build())
                .build();
        TurboHostSettingsUploadResponse result = turboFeedPreviewService.uploadHostSettings(
                request.getHostId(), fakeSettings, new TurboDesktopSettingsBuilder().build(), null, true);
        List<TurboErrorInfo> errors = new ArrayList<>();

        for (TurboRawError rawError : result.collectTurboRawErrors()) {
            TurboErrorType type = TurboErrorType.fromRawError(rawError);
            if (type == null || type == TurboErrorType.UNKNOWN) {
                continue; // игнорируемая ошибка
            }
            errors.add(TurboErrorInfo.fromRawError(type, rawError));
        }

        return new Response(errors);
    }

    @Required
    public void setTurboFeedPreviewService(TurboFeedPreviewService turboFeedPreviewService) {
        this.turboFeedPreviewService = turboFeedPreviewService;
    }

    public static final class Request extends AbstractUserVerifiedHostRequest {

        private String value;

        public String getValue() {
            return value;
        }

        @RequestQueryProperty(required = true)
        @Description("Искомый текст блока")
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static final class Response implements ActionResponse.NormalResponse {

        private final List<TurboErrorInfo> errors;

        public Response(List<TurboErrorInfo> errors) {
            this.errors = errors;
        }

        @Description("Критичные ошибки")
        public List<TurboErrorInfo> getErrors() {
            return errors;
        }
    }

}
