package ru.yandex.webmaster3.viewer.http.turbo.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * @author avhaliullin
 */
@Builder
@Value
@AllArgsConstructor(onConstructor_ = @JsonCreator)
public class GetTurboDashboardInfoResponse implements ActionResponse.NormalResponse {
    @Description("Принята ли оферта")
    boolean turboOfferAccepted;
    @Description("Количество савтопаршеных не включеных страниц")
    long autoparsedPagesCount;
    @Description("Автопарсер включен")
    boolean autoparserEnabled;
    @Description("Включены турбо-источники (включая API и автопарсер)")
    boolean hasTurboSources;
    @Description("Количество турбированных страниц на поиске")
    long turboPagesOnSearch;
    @Description("Всего турбо-страниц")
    long totalTurboPages;
    @Description("Количество турбо-проблем")
    int turboProblemsCount;
    @Description("Настроена ли турбо-реклама")
    boolean advertisementConfigured;
    @Description("Настроена ли турбо-аналитика")
    boolean analyticsConfigured;
    @Description("У хоста есть активные источники из API")
    boolean hasApiSources;
    @Description("У хоста есть активные источники RSS")
    boolean hasRssSources;
    @Description("У хоста есть активные источники YML")
    boolean hasYmlSources;
    @Description("У хоста включена автолента (бесконечная лента)")
    boolean autoRelatedEnabled;
    @Description("Сколько всего кликов в серпе было за последнюю неделю")
    long totalClicks;
    @Description("Сколько турбо-кликов в серпе было за последнюю неделю")
    long turboClicks;
    @Description("Сколько автоспаршенных кликов в серпе было за последнюю неделю")
    long autoparsedClicks;
    @Description("Автоморда доступна, но отключена")
    boolean autoMordaAvailableButOff;
    @Description("WMC-8236: показывать тизер для интернет магазинов без Турбо, но с Yml фидами")
    boolean showTeaserForStoreWithYmlFeedsWithoutTurbo;
    @Description("WMC-8236: показывать тизер для контентных сайтов без Турбо, но с Rss фидами")
    boolean showTeaserForNoStoreWithRssFeedsWithoutTurbo;
    @Description("WMC-8913: Турбо-корзина включена")
    boolean turboCartEnabled;
    @Description("WMC-8913: Оплаты включены")
    boolean paymentsEnabled;
    @Description("WMC-8913: Интеграция с Битриксом включена")
    boolean bitrixEnabled;
    @Description("WMC-8913: На сайте используется CMS Bitrix")
    boolean hasBitrixCMS;

    // найстройки добавились при разделении турбо
    boolean hasTurboShopSources;
    boolean hasTurboContentSources;

    long turboShopPagesOnSearch;
    long turboContentPagesOnSearch;

    int turboShopProblemsCount;
    int turboContentProblemsCount;
}
