package ru.yandex.webmaster3.viewer.http.turbo.feed;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedInfo;

/**
 * Created by Oleg Bazdyrev on 02/08/2017.
 */
public abstract class ActivateTurboFeedResponse implements ActionResponse {

    public enum ActivateTurboFeedError {
        ACTIVATE_TURBO_FEED__FEED_NOT_EXISTS,
        ACTIVATE_TURBO_FEED__NEED_TO_ACCEPT_OFFER,
        ACTIVATE_TURBO_FEED__NOT_VALIDATED,
        ACTIVATE_TURBO_FEED__INVALID_COMMERCE_SETTINGS,
        ACTIVATE_TURBO_FEED__BANNED_FEED,
    }

    public static class NormalResponse extends ActivateTurboFeedResponse implements ActionResponse.NormalResponse {
        private final TurboFeedInfo feed;

        public NormalResponse(TurboFeedInfo feed) {
            this.feed = feed;
        }

        @Description("Информация о источнике")
        public TurboFeedInfo getFeed() {
            return feed;
        }
    }

    @Description("Данный фид отсутствует в списке")
    public static class FeedNotExistsErrorResponse extends ActivateTurboFeedResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return ActivateTurboFeedError.ACTIVATE_TURBO_FEED__FEED_NOT_EXISTS;
        }
    }

    @Description("Необходимо принять оферту для активации")
    public static class NeedToAcceptOfferErrorResponse extends ActivateTurboFeedResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return ActivateTurboFeedError.ACTIVATE_TURBO_FEED__NEED_TO_ACCEPT_OFFER;
        }
    }

    @Description("Фид еще не прошел валидацию XSD")
    public static class NotValidatedErrorResponse extends ActivateTurboFeedResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return ActivateTurboFeedError.ACTIVATE_TURBO_FEED__NOT_VALIDATED;
        }
    }

    @Description("Некорректные настройки e-commerce")
    public static class InvalidCommerceSettingsResponse extends ActivateTurboFeedResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return ActivateTurboFeedError.ACTIVATE_TURBO_FEED__INVALID_COMMERCE_SETTINGS;
        }
    }
    @Description("Фид забанен")
    public static class BannedFeedResponse extends ActivateTurboFeedResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return ActivateTurboFeedError.ACTIVATE_TURBO_FEED__BANNED_FEED;
        }
    }
}
