package ru.yandex.webmaster3.viewer.http.turbo.feed;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedInfo;

/**
 * Created by Oleg Bazdyrev on 02/08/2017.
 */
public abstract class AddTurboFeedResponse implements ActionResponse {

    public enum AddTurboFeedError {
        ADD_TURBO_FEED__FEED_ALREADY_ADDED,
        ADD_TURBO_FEED__INVALID_FEED_URL,
        ADD_TURBO_FEED__URL_IS_NOT_FROM_HOST,
        ADD_TURBO_FEED__QUOTA_EXCEEDED,
        ADD_TURBO_FEED__BANNED_FEED,
    }

    public static class NormalResponse extends AddTurboFeedResponse implements ActionResponse.NormalResponse {

        private final TurboFeedInfo feed;

        public NormalResponse(TurboFeedInfo feed) {
            this.feed = feed;
        }

        @Description("Информация о свежедобавленном источнике")
        public TurboFeedInfo getFeed() {
            return feed;
        }
    }

    @Description("Данный фид уже был добавлен в список")
    public static class FeedAlreadyAddedErrorResponse extends AddTurboFeedResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return AddTurboFeedError.ADD_TURBO_FEED__FEED_ALREADY_ADDED;
        }
    }

    @Description("Некорректный формат адреса фида")
    public static class InvalidFeedUrlErrorResponse extends AddTurboFeedResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return AddTurboFeedError.ADD_TURBO_FEED__INVALID_FEED_URL;
        }
    }

    @Description("URL принадлежит другому хосту")
    public static class UrlIsNotFromHostErrorResponse extends AddTurboFeedResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return AddTurboFeedError.ADD_TURBO_FEED__URL_IS_NOT_FROM_HOST;
        }
    }

    @Description("URL принадлежит другому хосту")
    public static class BannedFeedResponse extends AddTurboFeedResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return AddTurboFeedError.ADD_TURBO_FEED__BANNED_FEED;
        }
    }

    @Description("Добавлено максимально возможное количество источников")
    public static class QuotaExceededErrorResponse extends AddTurboFeedResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return AddTurboFeedError.ADD_TURBO_FEED__QUOTA_EXCEEDED;
        }
    }
}
