package ru.yandex.webmaster3.viewer.http.turbo.feed;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

public abstract class BanTurboUrlResponse implements ActionResponse {
    public enum BanTurboUrlError {
        BAN_TURBO_URL__BAD_TURBO_URL,
        BAN_TURBO_URL__BAD_DOMAIN,
    }

    public static class NormalResponse extends BanTurboUrlResponse implements ActionResponse.NormalResponse {
    }

    @Description("Некорректный турбо урл")
    public static class BadTurboUrlResponse extends BanTurboUrlResponse implements ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return BanTurboUrlError.BAN_TURBO_URL__BAD_TURBO_URL;
        }
    }

    @Description("Турбо урл не соответствует хосту")
    public static class BadDomainResponse extends BanTurboUrlResponse implements ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return BanTurboUrlError.BAN_TURBO_URL__BAD_DOMAIN;
        }
    }
}
