package ru.yandex.webmaster3.viewer.http.turbo.feed;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Category;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.turbo.TurboToolsBanUrlService;
import ru.yandex.webmaster3.core.turbo.TurboUrlBanServiceResponse;
import ru.yandex.webmaster3.core.util.WwwUtil;

@Slf4j
@ReadAction
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("/turbo/urls/banUrlFromFeed")
@Category("turbo")
public class BanUrlFromFeedAction extends Action<BanUrlFromFeedRequest, BanUrlFromFeedResponse> {
    private final TurboToolsBanUrlService turboToolsBanUrlService;

    @Override
    public BanUrlFromFeedResponse process(BanUrlFromFeedRequest request) throws WebmasterException {
        String domain = WwwUtil.cutWWWAndM(request.getHostId());
        TurboUrlBanServiceResponse response = turboToolsBanUrlService.banUrl(domain, request.getUrl());
        log.info("ban request answer: {}", response.toString());
        if (response.isSuccess()) {
            return new BanUrlFromFeedResponse.NormalResponse();
        } else {
            return new BanUrlFromFeedResponse.FeedNotExistsErrorResponse();
        }
    }
}
