package ru.yandex.webmaster3.viewer.http.turbo.feed;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

public abstract class BanUrlFromFeedResponse implements ActionResponse {
    public enum BanUrlFromFeedError {
        BAN_URL_FROM_FEED__URL_NOT_EXISTS_IN_FEED,
    }

    public static class NormalResponse extends BanUrlFromFeedResponse implements ActionResponse.NormalResponse {
    }

    @Description("Данный урл отсутствует в фиде")
    public static class FeedNotExistsErrorResponse extends BanUrlFromFeedResponse implements ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return BanUrlFromFeedError.BAN_URL_FROM_FEED__URL_NOT_EXISTS_IN_FEED;
        }
    }
}
