package ru.yandex.webmaster3.viewer.http.turbo.feed;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.turbo.model.error.TurboErrorType;
import ru.yandex.webmaster3.viewer.http.turbo.feed.GetSupportedTurboErrorsAction.Request;
import ru.yandex.webmaster3.viewer.http.turbo.feed.GetSupportedTurboErrorsAction.Response;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by Oleg Bazdyrev on 06/07/2017.
 */
@ReadAction
@Category("turbo")
@Description("Получение списка поддерживаемых ошибок турбо (исходных кодов)")
public class GetSupportedTurboErrorsAction extends Action<Request, Response> {

    @Override
    public Response process(Request request) {
        List<String> codes = Arrays.stream(TurboErrorType.values())
                .flatMap(errorType -> Arrays.stream(errorType.getCodes()))
                .sorted().distinct().collect(Collectors.toList());
        return new Response(codes);
    }

    public static final class Request implements ActionRequest {

    }

    public static final class Response implements ActionResponse.NormalResponse {

        private final List<String> codes;

        public Response(List<String> codes) {
            this.codes = codes;
        }

        @Description("Список поддерживаемых кодов ошибок")
        public List<String> getCodes() {
            return codes;
        }
    }
}
