package ru.yandex.webmaster3.viewer.http.turbo.feed;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedInfo;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedInfo.TurboFeedInfoState;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedType;
import ru.yandex.webmaster3.core.turbo.model.statistics.TurboTotalStatistics;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

/**
 * Created by Oleg Bazdyrev on 23/08/2017.
 */
public abstract class GetTurboFeedsResponse implements ActionResponse {

    public static class NormalResponse extends GetTurboFeedsResponse implements ActionResponse.NormalResponse {

        private final int totalFeeds;
        private final List<TurboFeedInfo> feeds;
        private final TurboFeedInfo lastApiFeed;
        private final EnumSet<TurboFeedType> types = EnumSet.noneOf(TurboFeedType.class);
        private final EnumSet<TurboFeedInfoState> states = EnumSet.noneOf(TurboFeedInfoState.class);
        private final TurboTotalStatistics turboTotalStatistics;

        public NormalResponse(int totalFeeds, List<TurboFeedInfo> feeds,
                              Collection<TurboFeedType> types, Collection<TurboFeedInfoState> states,
                              TurboFeedInfo lastApiFeed, TurboTotalStatistics turboTotalStatistics) {
            this.totalFeeds = totalFeeds;
            this.feeds = feeds;
            this.lastApiFeed = lastApiFeed;
            this.turboTotalStatistics = turboTotalStatistics;
            this.types.addAll(types);
            this.states.addAll(states);
        }

        @Description("Всего фидов (попадающих под фильтр)")
        public int getTotalFeeds() {
            return totalFeeds;
        }

        @Description("Список турбо-фидов для источника")
        public List<TurboFeedInfo> getFeeds() {
            return feeds;
        }

        @Description("Последний загруженный через API фид (null - если такого нет)")
        public TurboFeedInfo getLastApiFeed() {
            return lastApiFeed;
        }

        @Description("Типы фидов для хоста")
        public EnumSet<TurboFeedType> getTypes() {
            return types;
        }

        @Description("Статусы фидов для хоста")
        public EnumSet<TurboFeedInfoState> getStates() {
            return states;
        }

        @Description("Общая статистика по всем фидам (в том числе уже удаленным) данного оунера")
        public TurboTotalStatistics getTurboTotalStatistics() {
            return turboTotalStatistics;
        }
    }

}
