package ru.yandex.webmaster3.viewer.http.turbo.feed;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.turbo.model.TurboUrl;

import java.util.List;

/**
 * Created by Oleg Bazdyrev on 23/08/2017.
 */
public abstract class GetTurboUrlsResponse implements ActionResponse {

    public static class NormalResponse extends GetTurboUrlsResponse implements ActionResponse.NormalResponse {

        private final boolean preview;
        private final List<TurboUrl> turboUrls;

        public NormalResponse(boolean preview, List<TurboUrl> turboUrls) {
            this.preview = preview;
            this.turboUrls = turboUrls;
        }

        @Description("true - режим превью (отладка), false - прод")
        public boolean isPreview() {
            return preview;
        }

        @Description("Список турбо-страниц для заданного фида")
        public List<TurboUrl> getTurboUrls() {
            return turboUrls;
        }
    }

}
