package ru.yandex.webmaster3.viewer.http.turbo.feed;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.turbo.service.TurboFeedsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;
import ru.yandex.webmaster3.viewer.http.turbo.feed.IsTurboFeedsEmptyAction.Request;
import ru.yandex.webmaster3.viewer.http.turbo.feed.IsTurboFeedsEmptyAction.Response;

/**
 * Created by Oleg Bazdyrev on 06/07/2017.
 */
@ReadAction
@Category("turbo")
@Description("Проверяет, есть ли у хоста турбо-фиды")
public class IsTurboFeedsEmptyAction extends AbstractUserVerifiedHostAction<Request, Response> {

    @Autowired
    private TurboFeedsService turboFeedsService;

    @Override
    public Response process(Request request) {
        // затягиваем настройки из кассандры
        try {
            boolean empty = turboFeedsService.getFeeds(WwwUtil.cutWWWAndM(request.getHostId())).isEmpty();
            return new Response(empty);
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Error reading feeds from Cassandra",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }

    public static final class Request extends AbstractUserVerifiedHostRequest {

    }

    public static final class Response implements ActionResponse.NormalResponse {

        private final boolean empty;

        public Response(boolean empty) {
            this.empty = empty;
        }

        @Description("Отсутствуют ли турбо-фиды на данном хосте")
        public boolean isEmpty() {
            return empty;
        }
    }
}
