package ru.yandex.webmaster3.viewer.http.turbo.feed;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * Created by Oleg Bazdyrev on 02/08/2017.
 */
public abstract class RemoveTurboFeedResponse implements ActionResponse {

    public enum RemoveTurboFeedError {
        REMOVE_TURBO_FEED__FEED_NOT_EXISTS,
    }

    public static class NormalResponse extends RemoveTurboFeedResponse implements ActionResponse.NormalResponse {

    }

    @Description("Данный фид отсутствует в списке")
    public static class FeedNotExistsErrorResponse extends RemoveTurboFeedResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return RemoveTurboFeedError.REMOVE_TURBO_FEED__FEED_NOT_EXISTS;
        }
    }
}
