package ru.yandex.webmaster3.viewer.http.turbo.feed;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedInfo;

/**
 * Created by Oleg Bazdyrev on 02/08/2017.
 */
public abstract class RevalidateTurboFeedResponse implements ActionResponse {

    public enum RevalidateTurboFeedError {
        REVALIDATE_TURBO_FEED__FEED_NOT_EXISTS,
    }

    public static class NormalResponse extends RevalidateTurboFeedResponse implements ActionResponse.NormalResponse {
        private final TurboFeedInfo feed;

        public NormalResponse(TurboFeedInfo feed) {
            this.feed = feed;
        }

        @Description("Информация о источнике")
        public TurboFeedInfo getFeed() {
            return feed;
        }
    }

    @Description("Данный фид отсутствует в списке")
    public static class FeedNotExistsErrorResponse extends RevalidateTurboFeedResponse implements ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return RevalidateTurboFeedError.REVALIDATE_TURBO_FEED__FEED_NOT_EXISTS;
        }
    }
}
