package ru.yandex.webmaster3.viewer.http.turbo.feed.history;

import java.util.List;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedInfo;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedSettings;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedStatistics;
import ru.yandex.webmaster3.core.turbo.model.statistics.TurboTotalStatistics;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.turbo.dao.TurboFeedsHistoryCHDao;
import ru.yandex.webmaster3.storage.turbo.dao.statistics.TurboDomainStatisticsHistoryYDao;
import ru.yandex.webmaster3.storage.turbo.service.TurboFeedsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * Created by Oleg Bazdyrev on 02/03/2018.
 */
@ReadAction
@Category("turbo")
@Description("Получение истории обхода фида (сколько айтемов в какой момент было, какие ошибки)")
@Component("/turbo/feed/history")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetTurboFeedHistoryAction extends
        AbstractUserVerifiedHostAction<GetTurboFeedHistoryRequest, GetTurboFeedHistoryResponse> {

    private final TurboDomainStatisticsHistoryYDao turboDomainStatisticsHistoryYDao;
    private final TurboFeedsHistoryCHDao turboFeedsHistoryCHDao;
    private final TurboFeedsService turboFeedsService;

    @Override
    public GetTurboFeedHistoryResponse process(GetTurboFeedHistoryRequest request) {
        String domain = WwwUtil.cutWWWAndM(request.getHostId());
        String feed = request.getFeedUrl();
        LocalDate date = request.getDate();
        TurboFeedSettings settings = turboFeedsService.getFeed(domain, feed);
        if (settings == null) {
            return new GetTurboFeedHistoryResponse.FeedNotExistsResponse();
        }

        List<TurboFeedStatistics> statsList = turboFeedsHistoryCHDao.getStatistics(domain, feed, date);

        List<TurboFeedInfo> feedUpdates = statsList.stream()
                .map(statistics -> new TurboFeedInfo(settings, statistics, null))
                .collect(Collectors.toList());

        // общая статистика

        TurboTotalStatistics totalStatistics = turboDomainStatisticsHistoryYDao.getFeedStatistics(domain, date, feed, settings.getType());

        return new GetTurboFeedHistoryResponse.NormalResponse(settings.getAddDate(), totalStatistics, feedUpdates);
    }
}
