package ru.yandex.webmaster3.viewer.http.turbo.feed.history;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedInfo;
import ru.yandex.webmaster3.core.turbo.model.statistics.TurboTotalStatistics;

import java.util.List;

import static ru.yandex.webmaster3.viewer.http.turbo.feed.history.GetTurboFeedHistoryResponse.ErrorCode.GET_TURBO_FEED_HISTORY__FEED_NOT_EXISTS;

/**
 * Created by Oleg Bazdyrev on 02/03/2018.
 */
public abstract class GetTurboFeedHistoryResponse implements ActionResponse {

    public enum ErrorCode {
        GET_TURBO_FEED_HISTORY__FEED_NOT_EXISTS,
    }

    public static final class NormalResponse extends GetTurboFeedHistoryResponse implements ActionResponse.NormalResponse {

        private final DateTime addDate;
        private final TurboTotalStatistics totalStatistics;
        private final List<TurboFeedInfo> feedUpdates;

        public NormalResponse(DateTime addDate, TurboTotalStatistics totalStatistics, List<TurboFeedInfo> feedUpdates) {
            this.addDate = addDate;
            this.totalStatistics = totalStatistics;
            this.feedUpdates = feedUpdates;
        }

        @Description("Дата добавления фида")
        public DateTime getAddDate() {
            return addDate;
        }

        @Description("Общая статистика в поиске для фида")
        public TurboTotalStatistics getTotalStatistics() {
            return totalStatistics;
        }

        @Description("История обновления фида")
        public List<TurboFeedInfo> getFeedUpdates() {
            return feedUpdates;
        }

    }

    public static final class FeedNotExistsResponse extends GetTurboFeedHistoryResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return GET_TURBO_FEED_HISTORY__FEED_NOT_EXISTS;
        }
    }
}
