package ru.yandex.webmaster3.viewer.http.turbo.host;

import lombok.RequiredArgsConstructor;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.turbo.dao.TurboDomainsWithAcceptedOfferYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * Created by ifilippov5 on 30.05.18.
 */
@ReadAction
@Category("turbo")
@Description("Принята ли оферта")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("/turbo/offer/get")
public class GetTurboOfferAction extends AbstractUserVerifiedHostAction<GetTurboOfferAction.Request, GetTurboOfferAction.Response> {

    private final TurboDomainsWithAcceptedOfferYDao turboDomainsWithAcceptedOfferYDao;

    @Override
    public Response process(Request request) {
        return new Response(turboDomainsWithAcceptedOfferYDao.contains(request.getHostId()));
    }

    public static class Request extends AbstractUserVerifiedHostRequest {
    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {
        @Description("Принята ли оферта")
        boolean offer;
    }
}
