package ru.yandex.webmaster3.viewer.http.turbo.host;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.turbo.dao.TurboDomainsWithAcceptedOfferYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * Created by ifilippov5 on 30.05.18.
 */
@WriteAction
@Category("turbo")
@Description("Принять оферту")
@Component("/turbo/offer/set")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class SetTurboOfferAction extends AbstractUserVerifiedHostAction<SetTurboOfferAction.Request, SetTurboOfferAction.Response> {

    private final TurboDomainsWithAcceptedOfferYDao turboDomainsWithAcceptedOfferYDao;

    @Override
    public Response process(Request request) {
        turboDomainsWithAcceptedOfferYDao.add(request.getHostId());
        return new Response();
    }

    public static class Request extends AbstractUserVerifiedHostRequest {
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
