package ru.yandex.webmaster3.viewer.http.turbo.host;

import org.apache.commons.collections4.CollectionUtils;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.turbo.model.TurboHostSettings;
import ru.yandex.webmaster3.core.turbo.model.TurboHostSettingsBlock;
import ru.yandex.webmaster3.core.turbo.model.desktop.TurboDesktopSettings;
import ru.yandex.webmaster3.core.turbo.model.desktop.TurboDesktopSettingsBlock;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

import java.util.EnumSet;
import java.util.List;

/**
 * Created by Oleg Bazdyrev on 01/03/2019.
 */
public class SetTurboSettingsRequest extends AbstractUserVerifiedHostRequest {

    private TurboHostSettings settings;
    private TurboDesktopSettings desktopSettings;
    private EnumSet<TurboHostSettingsBlock> settingsBlocks = EnumSet.noneOf(TurboHostSettingsBlock.class);
    private EnumSet<TurboDesktopSettingsBlock> desktopSettingsBlocks = EnumSet.noneOf(TurboDesktopSettingsBlock.class);

    public TurboHostSettings getSettings() {
        return settings;
    }

    @Description("Новые настройки Турбо для хоста")
    @RequestQueryProperty
    public void setSettings(TurboHostSettings settings) {
        this.settings = settings;
    }

    public TurboDesktopSettings getDesktopSettings() {
        return desktopSettings;
    }

    @Description("Настройки Турбо для десктопа")
    @RequestQueryProperty
    public void setDesktopSettings(TurboDesktopSettings desktopSettings) {
        this.desktopSettings = desktopSettings;
    }

    public EnumSet<TurboHostSettingsBlock> getSettingsBlocks() {
        return settingsBlocks;
    }

    @Description("Какие блоки настроек необходимо устанавливать. По умолчанию - все")
    @RequestQueryProperty
    public void setSettingsBlocks(List<TurboHostSettingsBlock> settingsBlocks) {
        if (!CollectionUtils.isEmpty(settingsBlocks)) {
            this.settingsBlocks = EnumSet.copyOf(settingsBlocks);
        }
    }

    public EnumSet<TurboDesktopSettingsBlock> getDesktopSettingsBlocks() {
        return  desktopSettingsBlocks;
    }

    @Description("Какие блоки настроек необходимо устанавливать (десктоп)")
    @RequestQueryProperty
    public void setDesktopSettingsBlocks(List<TurboDesktopSettingsBlock> desktopSettingsBlocks) {
        if (!CollectionUtils.isEmpty(desktopSettingsBlocks)) {
            this.desktopSettingsBlocks = EnumSet.copyOf(desktopSettingsBlocks);
        }
    }

}
