package ru.yandex.webmaster3.viewer.http.turbo.landing;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.turbo.model.landing.TurboLandingPreview;

import java.util.List;

/**
 * Created by Oleg Bazdyrev on 12/11/2018.
 */
public final class GetTurboLandingInfoResponse implements ActionResponse.NormalResponse {

    private final long turboHostCount;
    private final List<TurboLandingPreview> previews;

    public GetTurboLandingInfoResponse(long turboHostCount, List<TurboLandingPreview> previews) {
        this.turboHostCount = turboHostCount;
        this.previews = previews;
    }

    @Description("Сколько хостов подключено к турбо")
    public long getTurboHostCount() {
        return turboHostCount;
    }

    @Description("Избранные превьюшки")
    public List<TurboLandingPreview> getPreviews() {
        return previews;
    }

}
