package ru.yandex.webmaster3.viewer.http.turbo.logo;

import org.apache.commons.lang3.StringUtils;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.turbo.model.TurboHostHeaderType;

import java.util.Map;

/**
 * Created by ifilippov5 on 24.07.17.
 */
public abstract class UploadTurboLogoResponse implements ActionResponse {
    public static class NormalResponse extends UploadTurboLogoResponse implements ActionResponse.NormalResponse {
        @Description("id логотипа")
        private final String logoId;
        @Description("Ссылки на логотип в различных вариантах")
        private final Map<TurboHostHeaderType, String> logoUrls;
        @Description("SVG ли это")
        private final boolean svg;

        public NormalResponse(String logoId, Map<TurboHostHeaderType, String> logoUrls, boolean svg) {
            this.logoId = logoId;
            this.logoUrls = logoUrls;
            this.svg = svg;
        }

        public String getLogoId() {
            return logoId;
        }

        public Map<TurboHostHeaderType, String> getLogoUrls() {
            return logoUrls;
        }

        public boolean getSvg() {
            return svg;
        }
    }

    public enum UploadTurboLogoErrorType {
        UPLOAD_TURBO_LOGO__LOGO_IS_EMPTY,
        UPLOAD_TURBO_LOGO__LOGO_IS_TOO_LONG,
        UPLOAD_TURBO_LOGO__LOGO_IS_TOO_SMALL,
        UPLOAD_TURBO_LOGO__UNABLE_TO_DOWNLOAD_LOGO_BY_URL,
        UPLOAD_TURBO_LOGO__UNSUPPORTED_FORMAT,
    }

    static abstract class BaseErrorResponse extends UploadTurboLogoResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;
        protected BaseErrorResponse(Class<?> clazz) {this.clazz = clazz;}
        @Override public Class<?> getClazz() {return clazz;}
    }

    public static class LogoIsEmptyResponse extends UploadTurboLogoResponse.BaseErrorResponse {
        public LogoIsEmptyResponse(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return UploadTurboLogoErrorType.UPLOAD_TURBO_LOGO__LOGO_IS_EMPTY;}
        @Override public String getMessage() {return "Logo is empty";}
    }

    public static class LogoIsTooLongResponse extends UploadTurboLogoResponse.BaseErrorResponse {
        private final String message;

        public LogoIsTooLongResponse(Class<?> clazz, String message) {
            super(clazz);
            this.message = message;
        }
        @Override public Enum<?> getCode() {return UploadTurboLogoErrorType.UPLOAD_TURBO_LOGO__LOGO_IS_TOO_LONG;}
        @Override public String getMessage() {return "Logo is too long: " + StringUtils.trimToEmpty(message);}
    }

    public static class LogoIsTooSmallResponse extends UploadTurboLogoResponse.BaseErrorResponse {
        public LogoIsTooSmallResponse(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return UploadTurboLogoErrorType.UPLOAD_TURBO_LOGO__LOGO_IS_TOO_SMALL;}
        @Override public String getMessage() {return "Logo is too small";}
    }

    public static class UnableToDownloadLogoByUrlResponse extends UploadTurboLogoResponse.BaseErrorResponse {
        public UnableToDownloadLogoByUrlResponse(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return UploadTurboLogoErrorType.UPLOAD_TURBO_LOGO__UNABLE_TO_DOWNLOAD_LOGO_BY_URL;}
        @Override public String getMessage() {return "Unable to download logo by url";}
    }

    @Description("Неподдерживаемый формат")
    public static class UnsupportedFormatResponse extends UploadTurboLogoResponse.BaseErrorResponse {
        public UnsupportedFormatResponse(Class<?> clazz) {super(clazz);}
        @Override public Enum<?> getCode() {return UploadTurboLogoErrorType.UPLOAD_TURBO_LOGO__UNSUPPORTED_FORMAT;}
        @Override public String getMessage() {return "Unsupported file format"; }
    }

}