package ru.yandex.webmaster3.viewer.http.turbo.sandbox;

import java.util.EnumSet;
import java.util.Set;

import lombok.Getter;
import lombok.Setter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.turbo.model.TurboHostSettings;
import ru.yandex.webmaster3.core.turbo.model.TurboHostSettingsBlock;
import ru.yandex.webmaster3.core.turbo.model.commerce.TurboCommerceSettingsBlock;
import ru.yandex.webmaster3.core.turbo.model.commerce.TurboNewCommerceSettings;
import ru.yandex.webmaster3.core.turbo.model.desktop.TurboDesktopSettings;
import ru.yandex.webmaster3.core.turbo.model.desktop.TurboDesktopSettingsBlock;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedType;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * Created by Oleg Bazdyrev on 17/04/2018.
 */
@Getter
@Setter(onMethod_ = @RequestQueryProperty)
public class CreateTurboPreviewRequest extends AbstractUserVerifiedHostRequest {

    @Description("Содержимое турбо-страницы для создания превью. По умолчанию используется некий дефолтный контент")
    private String content;
    @Description("Кастомный css для отладки")
    private String css;
    @Description("Десктопный css для отладки")
    private String desktopCss;
    @Description("Суффикс для фиктивного урла страницы")
    private String urlSuffix;
    @Description("Настройки турбо для хоста - применяются только этого конкретного превью")
    private TurboHostSettings settings;
    @Description("Настройки Турбо для десктопа")
    private TurboDesktopSettings desktopSettings;
    @Description("Настройки Турбо для нового е-коммерс")
    private TurboNewCommerceSettings commerceSettings;
    @Description("Какие блоки настроек использовать для превью. По умолчанию - все")
    private Set<TurboHostSettingsBlock> settingsBlocks = EnumSet.noneOf(TurboHostSettingsBlock.class);
    @Description("Какие блоки настроек использовать для превью. По умолчанию - все")
    private Set<TurboDesktopSettingsBlock> desktopSettingsBlocks = EnumSet.noneOf(TurboDesktopSettingsBlock.class);
    private Set<TurboCommerceSettingsBlock> commerceSettingBlocks = EnumSet.noneOf(TurboCommerceSettingsBlock.class);
    @Description("Какое превью нужно по RSS или YML")
    private TurboFeedType type = TurboFeedType.RSS;

}
