package ru.yandex.webmaster3.viewer.http.turbo.sandbox;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboErrorInfo;
import ru.yandex.webmaster3.storage.turbo.service.css.TurboCssErrorInfo;

import java.util.List;

/**
 * Created by Oleg Bazdyrev on 17/04/2018.
 */
public abstract class CreateTurboPreviewResponse implements ActionResponse {

    public enum ErrorCode {
        CREATE_TURBO_PREVIEW__INVALID_ROOT_TAG,
    }

    public static final class NormalResponse extends CreateTurboPreviewResponse implements ActionResponse.NormalResponse {
        private final String previewUrl;
        private final List<TurboErrorInfo> warnings;
        private final List<TurboErrorInfo> errors;
        private final List<TurboCssErrorInfo> cssErrors;
        private final List<TurboCssErrorInfo> desktopCssErrors;

        public NormalResponse(String previewUrl, List<TurboErrorInfo> warnings, List<TurboErrorInfo> errors,
                              List<TurboCssErrorInfo> cssErrors, List<TurboCssErrorInfo> desktopCssErrors) {
            this.previewUrl = previewUrl;
            this.warnings = warnings;
            this.errors = errors;
            this.cssErrors = cssErrors;
            this.desktopCssErrors = desktopCssErrors;
        }

        @Description("Ссылка на превью")
        public String getPreviewUrl() {
            return previewUrl;
        }

        @Description("Предупреждения при парсинге")
        public List<TurboErrorInfo> getWarnings() {
            return warnings;
        }

        @Description("Ошибки при парсинге")
        public List<TurboErrorInfo> getErrors() {
            return errors;
        }

        @Description("Ошибки css")
        public List<TurboCssErrorInfo> getCssErrors() {
            return cssErrors;
        }

        @Description("Ошибки десктопного css")
        public List<TurboCssErrorInfo> getDesktopCssErrors() {
            return desktopCssErrors;
        }
    }

    public static final class InvalidRootTagResponse extends CreateTurboPreviewResponse implements ActionResponse.ErrorResponse {

        @Override
        public Enum<?> getCode() {
            return ErrorCode.CREATE_TURBO_PREVIEW__INVALID_ROOT_TAG;
        }
    }


}
