package ru.yandex.webmaster3.viewer.http.turbo.sandbox;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.turbo.model.error.TurboErrorType;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedType;
import ru.yandex.webmaster3.storage.download.DownloadStatus;

/**
 * Created by Oleg Bazdyrev on 19/04/2018.
 */
public abstract class GetTurboErrorContentResponse implements ActionResponse {

    private final DownloadStatus status;

    public GetTurboErrorContentResponse(DownloadStatus status) {
        this.status = status;
    }


    // TODO
    public static ErrorResponse createErrorResponse(TurboErrorType error) {
        switch (error) {
            case FETCHER_DISALLOWED_IN_ROBOTS:
                return new DisallowedInRobotsResponse();
            case FETCHER_HTTP:
                return new HttpErrorResponse();
            case PARSER_EMPTY_XML:
                return new EmptyXmlResponse();
            case PARSER_XML_TOO_BIG:
                return new XmlTooBigResponse();
            case PARSER_NO_ITEMS:
                return new NoItemsResponse();
            case PARSER_NO_ITEMS_DUE_TO_CHANGED_FEED:
                return new NoItemsDueToChangedFeedResponse();
            case PARSER_NO_CHANNEL:
                return new NoChannelResponse();
            case PARSER_NOT_RSS:
                return new NotRssResponse();
            default:
                return new InternalErrorResponse();
        }
    }

    @Description("Результат скачки текста айтема")
    public DownloadStatus getStatus() {
        return status;
    }

    public static final class NormalResponse extends GetTurboErrorContentResponse implements ActionResponse.NormalResponse {

        private final TurboFeedType feedType;
        private final String content;

        public NormalResponse(DownloadStatus status, TurboFeedType feedType, String content) {
            super(status);
            this.feedType = feedType;
            this.content = content;
        }

        @Description("Тип фида")
        public TurboFeedType getFeedType() {
            return feedType;
        }

        @Description("Текст айтема")
        public String getContent() {
            return content;
        }
    }

    public static abstract class ErrorResponse extends GetTurboErrorContentResponse implements ActionResponse.ErrorResponse {

        public ErrorResponse() {
            super(DownloadStatus.INTERNAL_ERROR);
        }
    }

    public static final class InternalErrorResponse extends ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return TurboErrorType.INTERNAL;
        }
    }

    public static final class HttpErrorResponse extends ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return TurboErrorType.FETCHER_HTTP;
        }
    }

    public static final class DisallowedInRobotsResponse extends ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return TurboErrorType.FETCHER_DISALLOWED_IN_ROBOTS;
        }
    }

    public static final class EmptyXmlResponse extends ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return TurboErrorType.PARSER_EMPTY_XML;
        }
    }

    public static final class XmlTooBigResponse extends ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return TurboErrorType.PARSER_XML_TOO_BIG;
        }
    }

    public static final class NoItemsResponse extends ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return TurboErrorType.PARSER_NO_ITEMS;
        }
    }

    public static final class NoItemsDueToChangedFeedResponse extends ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return TurboErrorType.PARSER_NO_ITEMS_DUE_TO_CHANGED_FEED;
        }
    }

    public static final class NoChannelResponse extends ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return TurboErrorType.PARSER_NO_CHANNEL;
        }
    }

    public static final class NotRssResponse extends ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return TurboErrorType.PARSER_NOT_RSS;
        }
    }

}
