package ru.yandex.webmaster3.viewer.http.turbo.scc;

import lombok.RequiredArgsConstructor;
import lombok.Value;
import lombok.extern.slf4j.Slf4j;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.turbo.dao.TurboDomainsStateCHDao;
import ru.yandex.webmaster3.storage.turbo.dao.app.TurboAppSettingsYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * ishalaru
 * 18.09.2020
 **/
@WriteAction
@Category("turbo")
@Slf4j
@Component("/turbo/scc/launch")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class LaunchSccProcessAction extends AbstractUserVerifiedHostAction<LaunchSccProcessAction.Request, LaunchSccProcessAction.Response> {

    private final TurboDomainsStateCHDao turboDomainsStateCHDao;
    private final TurboAppSettingsYDao turboAppSettingsYDao;

    @Override
    public Response process(Request request) {
        String domain = WwwUtil.cutWWWAndM(request.getHostId().getPunycodeHostname());

        turboAppSettingsYDao.updateSccLaunchTime(domain, DateTime.now());
        return new Response.NormalResponse();
    }

    public static class Request extends AbstractUserVerifiedHostRequest {

    }

    public static abstract class Response implements ActionResponse {

        @Value
        public static class ErrorResponse extends Response implements ActionResponse.ErrorResponse {

            @Override
            public Enum<?> getCode() {
                return Error.RELAUNCH_SCC_POSSIBLE_ONLY_IN_SUPPORT;
            }
        }

        @Value
        public static class NormalResponse extends Response implements ActionResponse.NormalResponse {
        }

    }

    private enum Error {
        RELAUNCH_SCC_POSSIBLE_ONLY_IN_SUPPORT
    }
}
