package ru.yandex.webmaster3.viewer.http.turbo.statistics;

import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Category;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.turbo.model.statistics.TurboTopUrlInfo;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.turbo.service.TurboClickStatisticsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * ishalaru
 * 12.03.2020
 **/
@ReadAction
@Description(value = "Информацию о не турбированных топовых страницах сайта")
@Category("turbo")
@Component("/turbo/statistics/url/clicks")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class TurboUrlsHistoryAction extends AbstractUserVerifiedHostAction<TurboUrlsHistoryAction.Request, TurboUrlsHistoryAction.Response> {

    private final TurboClickStatisticsService turboClickStatisticsService;

    @Override
    public Response process(Request request) {
        List<TurboTopUrlInfo> pairs = turboClickStatisticsService.topUrlsWithoutTurbo(WwwUtil.cutWWWAndM(request.getHostId()));
        if (pairs.size() > 10) {
            pairs = pairs.subList(0, 10);
        }
        return new Response(pairs);
    }


    public static class Request extends AbstractUserVerifiedHostRequest {
    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {
        List<TurboTopUrlInfo> list;
    }
}
