package ru.yandex.webmaster3.viewer.http.url.checker2;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.viewer.http.common.response.CommonHostInfo;
import ru.yandex.webmaster3.viewer.http.url.checker2.data.UrlCheckRequest;

/**
 * Created by leonidrom on 01/03/2017.
 */
public abstract class AddUrlCheckResponse implements ActionResponse {
    public static class NormalResponse extends AddUrlCheckResponse implements ActionResponse.NormalResponse {
        private final UrlCheckRequest request;

        public NormalResponse(UrlCheckRequest request) {
            this.request = request;
        }

        public UrlCheckRequest getRequest() {
            return request;
        }
    }

    public enum StartUrlCheckErrorCode {
        INVALID_URL,
        URL_IS_NOT_FROM_HOST,
        ADD_TO_ANOTHER_HOST,
        HOST_LIMIT_REACHED
    }

    public static abstract class AddUrlCheckErrorResponse extends AddUrlCheckResponse implements ActionResponse.ErrorResponse {
        private final StartUrlCheckErrorCode errorCode;

        public AddUrlCheckErrorResponse(StartUrlCheckErrorCode errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public Enum<?> getCode() {
            return errorCode;
        }
    }

    @Description("Передан невалидный URL")
    public static class InvalidUrlResponse extends AddUrlCheckErrorResponse {
        public InvalidUrlResponse() {
            super(StartUrlCheckErrorCode.INVALID_URL);
        }
    }

    @Description("URL принадлежит другому хосту, который не подтверждён")
    public static class UrlIsNotFromHostResponse extends AddUrlCheckErrorResponse {
        public UrlIsNotFromHostResponse() {
            super(StartUrlCheckErrorCode.URL_IS_NOT_FROM_HOST);
        }
    }

    @Description("URL принадлежит другому подтверждённому хосту и должен быть добавлен в контексте другого хоста")
    public static class AddToAnotherHostResponse extends AddUrlCheckErrorResponse {
        private final CommonHostInfo anotherHostInfo;

        public AddToAnotherHostResponse(CommonHostInfo anotherHostInfo) {
            super(StartUrlCheckErrorCode.ADD_TO_ANOTHER_HOST);
            this.anotherHostInfo = anotherHostInfo;
        }

        @Description("Информация о хосте, в контексте которого необходимо добавить URL")
        public CommonHostInfo getAnotherHostInfo() {
            return anotherHostInfo;
        }
    }

    @Description("Дневной лимит запросов для хоста исчерпан")
    public static class HostLimitReachedResponse extends AddUrlCheckErrorResponse {
        public HostLimitReachedResponse() {
            super(StartUrlCheckErrorCode.HOST_LIMIT_REACHED);
        }
    }
}

