package ru.yandex.webmaster3.viewer.http.url.checker2;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.url.checker2.UrlCheckRequestService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * Created by leonidrom on 09/03/2017.
 */
@WriteAction
@Category("checkurl")
public class DeleteUrlCheckRequestAction extends AbstractUserVerifiedHostAction<DeleteUrlCheckRequestRequest, DeleteUrlCheckRequestResponse> {
    private UrlCheckRequestService urlCheckRequestService;

    @Override
    public DeleteUrlCheckRequestResponse process(DeleteUrlCheckRequestRequest request) {
        urlCheckRequestService.deleteResultAndRequest(request.getHostId(), request.getRequestId());

        return new DeleteUrlCheckRequestResponse.NormalResponse();
    }

    @Required
    public void setUrlCheckRequestService(UrlCheckRequestService urlCheckRequestService) {
        this.urlCheckRequestService = urlCheckRequestService;
    }
}
