package ru.yandex.webmaster3.viewer.http.url.checker2;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.viewer.http.url.checker2.data.UrlCheckReport;

/**
 * Created by leonidrom on 01/03/2017.
 */
public abstract class GetUrlCheckReportResponse implements ActionResponse {
    public static class NormalResponse extends GetUrlCheckReportResponse implements ActionResponse.NormalResponse {
        private final UrlCheckReport report;

        public NormalResponse(UrlCheckReport report) {
            this.report = report;
        }

        public UrlCheckReport getReport() {
            return report;
        }
    }

    public enum GetUrlCheckReportErrorCode {
        REQUEST_NOT_FOUND,
        REPORT_NOT_READY,
    }

    public static abstract class GetUrlCheckReportErrorResponse extends GetUrlCheckReportResponse implements ActionResponse.ErrorResponse {
        private final GetUrlCheckReportErrorCode errorCode;

        public GetUrlCheckReportErrorResponse(GetUrlCheckReportErrorCode errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public Enum<?> getCode() {
            return errorCode;
        }
    }

    @Description("Заявка с заданным идентификатором отсутствует")
    public static class RequestNotFoundErrorResponse extends GetUrlCheckReportErrorResponse {
        public RequestNotFoundErrorResponse() {
            super(GetUrlCheckReportErrorCode.REQUEST_NOT_FOUND);
        }
    }

    @Description("Отчёт ещё не готов, вернитесь позже")
    public static class ReportNotReadyErrorResponse extends GetUrlCheckReportErrorResponse {
        public ReportNotReadyErrorResponse() {
            super(GetUrlCheckReportErrorCode.REPORT_NOT_READY);
        }
    }
}
