package ru.yandex.webmaster3.viewer.http.url.checker2;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

import java.util.List;

/**
 * Created by leonidrom on 01/03/2017.
 */
public class GetUrlCheckRequestListRequest extends AbstractUserVerifiedHostRequest implements PagerAware {
    private List<UrlCheckRequestFilter> parameterFilters;

    private int p = 0;
    private int pSize = 20;

    public int getP() {
        return p;
    }

    public int getPSize() {
        return pSize;
    }

    public List<UrlCheckRequestFilter> getParameterFilters() {
        return parameterFilters;
    }

    @Override
    public void setP(int p) {
        this.p = p;
    }

    @Override
    public void setPSize(int pSize) {
        this.pSize = pSize;
    }

    @Description("Фильтр по полям")
    @RequestPostProperty
    public void setParameterFilters(List<UrlCheckRequestFilter> parameterFilters) {
        this.parameterFilters = parameterFilters;
    }
}
