package ru.yandex.webmaster3.viewer.http.url.checker2;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.viewer.http.url.checker2.data.UrlCheckRequest;

import java.util.List;

/**
 * Created by leonidrom on 01/03/2017.
 */
public abstract class GetUrlCheckRequestListResponse implements ActionResponse {
    public static class NormalResponse extends GetUrlCheckRequestListResponse implements ActionResponse.NormalResponse {
        private final long totalRequests;
        private final List<UrlCheckRequest> requests;

        public NormalResponse(long totalRequests, List<UrlCheckRequest> requests) {
            this.totalRequests = totalRequests;
            this.requests = requests;
        }

        @Description("Количество заявок")
        public long getTotalRequests() {
            return totalRequests;
        }

        @Description("Сохраненные заявки")
        public List<UrlCheckRequest> getRequests() {
            return requests;
        }
    }
}
