package ru.yandex.webmaster3.viewer.http.url.checker2.data;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;

import java.net.URL;
import java.util.UUID;

/**
 * Created by leonidrom on 02/03/2017.
 */
public class UrlCheckRequest {
    private final URL url;
    private final UUID requestId;
    private final DateTime сreatedTime;
    private final UrlCheckRequestStatus status;
    private final UrlCheckReport report;

    public UrlCheckRequest(UUID requestId, URL url, DateTime createdTime,
                           UrlCheckRequestStatus status) {
        this(requestId, url, createdTime, status, null);
    }

    public UrlCheckRequest(UUID requestId, URL url, DateTime сreatedTime,
                           UrlCheckRequestStatus status, UrlCheckReport report) {
        this.url = url;
        this.requestId = requestId;
        this.сreatedTime = сreatedTime;
        this.status = status;
        this.report = report;
    }

    @Description("URL для проверки")
    public URL getUrl() {
        return url;
    }

    @Description("ID заявки")
    public UUID getRequestId() {
        return requestId;
    }

    @Description("Дата создания заявки")
    public DateTime getCreatedTime() {
        return сreatedTime;
    }

    @Description("Текущее состояние заявки")
    public UrlCheckRequestStatus getStatus() {
        return status;
    }

    @Description("Отчет по завершенной заявке")
    public UrlCheckReport getReport() {
        return report;
    }
}
