package ru.yandex.webmaster3.viewer.http.url.checker3;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.url.checker3.dao.UrlCheckRequests2YDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author leonidrom
 */
@WriteAction
@Category("checkurl")
@Component("/urlchecker3/deleteRequest")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class DeleteUrlCheckRequestAction extends AbstractUserVerifiedHostAction<DeleteUrlCheckRequestRequest, DeleteUrlCheckRequestResponse> {
    private final UrlCheckRequests2YDao urlCheckRequests2YDao;

    @Override
    public DeleteUrlCheckRequestResponse process(DeleteUrlCheckRequestRequest request) {
        urlCheckRequests2YDao.deleteRequest(request.getHostId(), request.getRequestId());
        return new DeleteUrlCheckRequestResponse.NormalResponse();
    }
}
