package ru.yandex.webmaster3.viewer.http.url.checker3;

import lombok.Data;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.HttpResponsePart;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;
import ru.yandex.webmaster3.core.util.json.JsonMapping;
import ru.yandex.webmaster3.storage.crawl.RotorSettings;
import ru.yandex.webmaster3.storage.url.checker3.data.UrlCheckDataBlock;
import ru.yandex.webmaster3.storage.url.checker3.data.UrlCheckDataBlockState;
import ru.yandex.webmaster3.storage.url.checker3.data.blocks.*;
import ru.yandex.webmaster3.viewer.http.crawl.data.UrlRotorCheckInfo;
import ru.yandex.webmaster3.viewer.http.url.checker3.data.PageContentResponseDataBlock;
import ru.yandex.webmaster3.viewer.http.url.checker3.data.SearchInfoResponseDataBlock;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

/**
 * @author leonidrom
 */
public abstract class GetUrlCheckInfoResponse implements ActionResponse {
    public enum ErrorCode {
        REQUEST_ID_NOT_FOUND,
        TIMED_OUT,
        INTERNAL_ERROR,
        UNABLE_TO_DOWNLOAD_CONTENT
    }

    public static abstract class GetUrlCheckErrorResponse extends GetUrlCheckInfoResponse implements ActionResponse.ErrorResponse {
        private final ErrorCode errorCode;

        public GetUrlCheckErrorResponse(ErrorCode errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public Enum<ErrorCode> getCode() {
            return errorCode;
        }

        @Override
        public Enum<?> getSubsystem() {
            return WebmasterCommonErrorSystem.INTERNAL;
        }
    }

    // not used, for autodoc to work correctly
    public static class NormalResponse extends GetUrlCheckInfoNormalResponse {
    }

    @Description("Запрос не найден")
    public static class RequestIdNotFoundResponse extends GetUrlCheckErrorResponse {
        public RequestIdNotFoundResponse() {
            super(ErrorCode.REQUEST_ID_NOT_FOUND);
        }
    }

    @Description("Проверка урла выполняется слишком долго")
    public static class TimedOutResponse extends GetUrlCheckErrorResponse {
        public TimedOutResponse() {
            super(ErrorCode.TIMED_OUT);
        }
    }

    @Description("Проверка урла не удалась из за внутренней ошибки")
    public static class InternalErrorResponse extends GetUrlCheckErrorResponse {
        public InternalErrorResponse() {
            super(ErrorCode.INTERNAL_ERROR);
        }
    }

    @Description("Не удалось скачать данные на стороне Робота")
    public static class UnableToDownloadContentResponse extends GetUrlCheckErrorResponse {
        public UnableToDownloadContentResponse() {
            super(ErrorCode.UNABLE_TO_DOWNLOAD_CONTENT);
        }
    }

}
