package ru.yandex.webmaster3.viewer.http.url.checker3;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.viewer.http.url.checker3.data.UrlCheckRequest;

import java.util.List;

/**
 * @author leonidrom
 */
public abstract class GetUrlCheckRequestListResponse implements ActionResponse {
    public static class NormalResponse extends GetUrlCheckRequestListResponse implements ActionResponse.NormalResponse {
        private final long totalRequests;
        private final List<UrlCheckRequest> requests;

        public NormalResponse(long totalRequests, List<UrlCheckRequest> requests) {
            this.totalRequests = totalRequests;
            this.requests = requests;
        }

        @Description("Количество заявок")
        public long getTotalRequests() {
            return totalRequests;
        }

        @Description("Сохраненные заявки")
        public List<UrlCheckRequest> getRequests() {
            return requests;
        }
    }
}
