package ru.yandex.webmaster3.viewer.http.url.checker3;

import lombok.Getter;
import lombok.With;
import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.url.checker3.UrlCheckRequestParams;
import ru.yandex.webmaster3.core.url.checker3.UrlCheckDeviceType;
import ru.yandex.webmaster3.core.zora.ZoraUserAgent;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author leonidrom
 */
@Getter
public class StartUrlCheckRequest extends AbstractUserVerifiedHostRequest {
    private final UrlCheckRequestParams requestParams = new UrlCheckRequestParams();

    @Description("URL для проверки")
    @RequestQueryProperty(required = true)
    public void setUrl(String url) {
        requestParams.url = url;
    }

    @Description("Тип проверки")
    @RequestQueryProperty(required = true)
    public void setDeviceType(UrlCheckDeviceType checkType) {
        requestParams.deviceType = checkType;
    }

    @Description("Тип User-Agent для запроса")
    @RequestQueryProperty
    public void setUserAgent(ZoraUserAgent userAgent) {
        requestParams.userAgent = userAgent;
    }

    @Description("Добавляет заголовок If-Modified-Since к запросу")
    @RequestQueryProperty
    public void setIfModifiedSince(DateTime ifModifiedSince) {
        requestParams.ifModifiedSince = ifModifiedSince;
    }

    public UrlCheckRequestParams getRequestParams() {
        return requestParams;
    }
}
