package ru.yandex.webmaster3.viewer.http.url.checker3;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.viewer.http.common.response.CommonHostInfo;

import java.util.UUID;

/**
 * @author leonidrom
 */
public abstract class StartUrlCheckResponse implements ActionResponse {
        public static class NormalResponse extends StartUrlCheckResponse implements ActionResponse.NormalResponse {
        private final UUID requestId;

        public NormalResponse(UUID requestId) {
            this.requestId = requestId;
        }

        @Description("id созданной заявки")
        public UUID getRequestId() {
            return requestId;
        }
    }

    public enum ErrorCode {
        INVALID_URL,
        URL_IS_NOT_FROM_HOST,
        ADD_TO_ANOTHER_HOST,
        HOST_LIMIT_REACHED,
        USER_LIMIT_REACHED
    }

    public static abstract class StartUrlRotorCheckErrorResponse extends StartUrlCheckResponse implements ActionResponse.ErrorResponse {
        private final ErrorCode errorCode;

        public StartUrlRotorCheckErrorResponse(ErrorCode errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public Enum<ErrorCode> getCode() {
            return errorCode;
        }
    }

    @Description("Передан невалидный URL")
    public static class InvalidUrlResponse extends StartUrlRotorCheckErrorResponse {
        public InvalidUrlResponse() {
            super(ErrorCode.INVALID_URL);
        }
    }

    @Description("URL принадлежит другому хосту, который не подтверждён")
    public static class UrlIsNotFromHostResponse extends StartUrlRotorCheckErrorResponse {
        public UrlIsNotFromHostResponse() {
            super(ErrorCode.URL_IS_NOT_FROM_HOST);
        }
    }

    @Description("URL принадлежит другому подтверждённому хосту и должен быть добавлен в контексте другого хоста")
    public static class AddToAnotherHostResponse extends StartUrlRotorCheckErrorResponse {
        private final CommonHostInfo anotherHostInfo;

        public AddToAnotherHostResponse(CommonHostInfo anotherHostInfo) {
            super(ErrorCode.ADD_TO_ANOTHER_HOST);
            this.anotherHostInfo = anotherHostInfo;
        }

        @Description("Информация о хосте, в контексте которого необходимо добавить URL")
        public CommonHostInfo getAnotherHostInfo() {
            return anotherHostInfo;
        }
    }

    @Description("Дневной лимит запросов для хоста исчерпан")
    public static class HostLimitReachedResponse extends StartUrlRotorCheckErrorResponse {
        public HostLimitReachedResponse() {
            super(ErrorCode.HOST_LIMIT_REACHED);
        }
    }

    @Description("Дневной лимит запросов для пользователя исчерпан")
    public static class UserLimitReachedResponse extends StartUrlRotorCheckErrorResponse {
        public UserLimitReachedResponse() {
            super(ErrorCode.USER_LIMIT_REACHED);
        }
    }
}
