package ru.yandex.webmaster3.viewer.http.url.checker3.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.json.JsonMapping;
import ru.yandex.webmaster3.storage.url.checker3.data.UrlCheckDataBlock;
import ru.yandex.webmaster3.storage.url.checker3.data.UrlCheckDataBlockState;
import ru.yandex.webmaster3.storage.url.checker3.data.blocks.PageTextContentData;

/**
 * @author leonidrom
 */
public class PageContentResponseDataBlock extends AbstractAsyncResponseDataBlock {
    private final String content;

    public PageContentResponseDataBlock(String content) {
        super(UrlCheckDataBlockState.DONE);
        this.content = content;
    }

    public PageContentResponseDataBlock(UrlCheckDataBlockState state) {
        super(state);
        this.content = null;
    }

    @Description("Опциональный контент страницы (текстовый архив или html)")
    public String getContent() {
        return content;
    }

    public static PageContentResponseDataBlock fromDataBlock(UrlCheckDataBlock pageContentDataBlock) {
        if (pageContentDataBlock.getFetchState() != UrlCheckDataBlockState.DONE) {
            return new PageContentResponseDataBlock(pageContentDataBlock.getFetchState());
        }

        var pageContentData = JsonMapping.readValue(pageContentDataBlock.getData(), PageTextContentData.class);
        return new PageContentResponseDataBlock(pageContentData.getText());
    }
}
