package ru.yandex.webmaster3.viewer.http.url.checker3.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.storage.url.checker3.data.UrlCheckDataBlockState;

/**
 * @author leonidrom
 */
@Description("Title и description страницы")
public class PageTitleDescriptionResponseDataBlock extends AbstractAsyncResponseDataBlock {
    private final String title;
    private final String description;

    public PageTitleDescriptionResponseDataBlock(String title, String description) {
        super(UrlCheckDataBlockState.DONE);

        this.title = title;
        this.description = description;
    }

    public PageTitleDescriptionResponseDataBlock(UrlCheckDataBlockState state) {
        super(state);

        this.title = null;
        this.description = null;
    }

    @Description("Опциональный title")
    public String getTitle() {
        return title;
    }

    @Description("Опциональный description")
    public String getDescription() {
        return description;
    }
}
