package ru.yandex.webmaster3.viewer.http.url.checker3.data;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.HttpResponsePart;
import ru.yandex.webmaster3.storage.url.checker3.data.UrlCheckDataBlockState;

/**
 * @author leonidrom
 */
public class ServerResponseResponseDataBlock extends AbstractAsyncResponseDataBlock {
    private final HttpResponsePart httpResponsePart;

    public ServerResponseResponseDataBlock(HttpResponsePart httpResponsePart) {
        super(UrlCheckDataBlockState.DONE);
        this.httpResponsePart = httpResponsePart;
    }

    public ServerResponseResponseDataBlock(UrlCheckDataBlockState state) {
        super(state);
        this.httpResponsePart = null;
    }

    @Description("Ответ сервера, как в /util/serverResponse/info")
    public HttpResponsePart getHttpResponsePart() {
        return httpResponsePart;
    }
}
