package ru.yandex.webmaster3.viewer.http.url.checker3.data;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.url.checker3.UrlCheckDeviceType;

import java.net.URL;
import java.util.UUID;

/**
 * @author leonidrom
 */
public class UrlCheckRequest {
    private final String url;
    private final UUID requestId;
    private final UrlCheckDeviceType deviceType;
    private final DateTime сreatedTime;

    public UrlCheckRequest(UUID requestId, String  url, UrlCheckDeviceType deviceType, DateTime сreatedTime) {
        this.url = url;
        this.requestId = requestId;
        this.deviceType = deviceType;
        this.сreatedTime = сreatedTime;
    }

    @Description("URL для проверки")
    public String getUrl() {
        return url;
    }

    @Description("ID заявки")
    public UUID getRequestId() {
        return requestId;
    }

    @Description("Тип устройства")
    public UrlCheckDeviceType getDeviceType() {
        return deviceType;
    }

    @Description("Дата создания заявки")
    public DateTime getCreatedTime() {
        return сreatedTime;
    }
}
