package ru.yandex.webmaster3.viewer.http.user;


import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.user.dao.DashboardSurveyAnswersYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

@ReadAction
@Category("user")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Component("/user/dashboardSurvey/isPresent")
public class DashboardSurveyIsPresentAction extends AbstractUserAction<DashboardSurveyIsPresentAction.Request,
        DashboardSurveyIsPresentAction.Response> {
    private final DashboardSurveyAnswersYDao dashboardSurveyAnswersYDao;

    @Override
    public Response process(Request request) {
        return new Response(dashboardSurveyAnswersYDao.contains(request.hostId,
                request.surveyType));
    }

    public static class Request extends AbstractUserRequest {
        @Setter(onMethod_ = {@Description("Тип опроса"), @RequestQueryProperty(required = true)})
        private String surveyType;
        @Setter(onMethod_ = {@Description("Хост"), @RequestQueryProperty(required = true)})
        private WebmasterHostId hostId;
    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {
        @Description("Отвечал ли хост на опрос")
        Boolean isPresent;
    }
}
