package ru.yandex.webmaster3.viewer.http.user;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.CommonRequestInfoAware;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

/**
 * @author aherman
 */
public class GetHostListRequest extends AbstractUserRequest implements  PagerAware, CommonRequestInfoAware {
    private int page;
    private int pageSize;
    private String userIp;
    private String yandexUid;
    private String frontendIp;
    private String hostnameFilter;

    @Override
    public void setP(int page) {
        this.page = page;
    }

    public int getPage() {
        return page;
    }

    @Override
    public void setPSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return pageSize;
    }

    @Override
    public void setUserIp(String ip) {
        this.userIp = ip;
    }

    public String getUserIp() {
        return userIp;
    }

    @Override
    public void setUserYandexUid(String yandexUid) {
        this.yandexUid = yandexUid;
    }

    public String getYandexUid() {
        return yandexUid;
    }

    @Override
    public void setFrontendIp(String ip) {
        frontendIp = ip;
    }

    public String getFrontendIp() {
        return frontendIp;
    }

    @Description(value="Фильтр по имени хоста")
    @RequestQueryProperty
    public void setHostnameFilter(String hostnameFilter) {
        this.hostnameFilter = hostnameFilter;
    }

    public String getHostnameFilter() {
        return hostnameFilter;
    }
}
