package ru.yandex.webmaster3.viewer.http.user;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * @author aherman
 */
public abstract class GetUserInfoResponse implements ActionResponse {
    public static class NormalResponse extends GetUserInfoResponse implements ActionResponse.NormalResponse {
        private final int verifiedHostsCount;
        private final int unverifiedHostsCount;
        private final WebmasterHostId singleVerifiedHost;

        public NormalResponse(int verifiedHostsCount, int unverifiedHostsCount, WebmasterHostId singleVerifiedHost) {
            this.verifiedHostsCount = verifiedHostsCount;
            this.unverifiedHostsCount = unverifiedHostsCount;
            this.singleVerifiedHost = singleVerifiedHost;
        }

        public int getVerifiedHostsCount() {
            return verifiedHostsCount;
        }

        public int getUnverifiedHostsCount() {
            return unverifiedHostsCount;
        }

        @Description("если у пользователя есть подтвержденный хост, причем ровно один - то он будет тут. Иначе - null")
        public WebmasterHostId getSingleVerifiedHost() {
            return singleVerifiedHost;
        }
    }
}
