package ru.yandex.webmaster3.viewer.http.user;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.user.service.UserHostsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserAddedHostAction;

/**
 * @author aherman
 */
@WriteAction
@Category("user")
@Description(value="Помечает хост как pinned (что влияет на сортировку в /user/host/list.json).\n" +
                   "Доступен для любых хостов.")
public class PinHostAction extends AbstractUserAddedHostAction<PinHostRequest, PinHostResponse> {
    private UserHostsService userHostsService;

    @Override
    public PinHostResponse process(PinHostRequest request) {
        userHostsService.changePinState(request.getWebmasterUser(), request.getHostId(), request.isPinned());
        return new PinHostResponse.NormalResponse(request.isPinned());
    }

    @Required
    public void setUserHostsService(UserHostsService userHostsService) {
        this.userHostsService = userHostsService;
    }
}
