package ru.yandex.webmaster3.viewer.http.user;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.request.CommonRequestInfoAware;
import ru.yandex.webmaster3.core.http.request.PagerAware;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

/**
 * @author aherman
 */
public class SuggestHostRequest extends AbstractUserRequest implements PagerAware, CommonRequestInfoAware {
    private String userIp;
    private String yandexUid;
    private String frontendIp;
    private int page;
    private int pageSize;
    private String hostnameFilter;

    @Override
    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    public String getUserIp() {
        return userIp;
    }

    @Override
    public void setUserYandexUid(String yandexUid) {
        this.yandexUid = yandexUid;
    }

    public String getYandexUid() {
        return yandexUid;
    }

    @Override
    public void setFrontendIp(String frontendIp) {
        this.frontendIp = frontendIp;
    }

    public String getFrontendIp() {
        return frontendIp;
    }

    @Override
    public void setP(int page) {
        this.page = page;
    }

    @Override
    public void setPSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return pageSize;
    }

    @Description(value="Фильтр по имени хоста")
    @RequestQueryProperty
    public void setHostnameFilter(String hostnameFilter) {
        this.hostnameFilter = hostnameFilter;
    }

    public String getHostnameFilter() {
        return hostnameFilter;
    }
}
