package ru.yandex.webmaster3.viewer.http.user;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;

import java.util.List;

/**
 * @author aherman
 */
public abstract class SuggestHostResponse implements ActionResponse {
    public static class NormalResponse extends SuggestHostResponse implements ActionResponse.NormalResponse {
        private final List<SuggestHostInfo> hostList;

        public NormalResponse(List<SuggestHostInfo> hostList) {
            this.hostList = hostList;
        }

        public List<SuggestHostInfo> getHostList() {
            return hostList;
        }
    }

    public static class SuggestHostInfo {
        private final WebmasterHostId.Schema schema;
        private final String displayName;
        private final String punycodeHostname;
        private final WebmasterHostId webmasterHostId;

        public SuggestHostInfo(WebmasterHostId hostId, String displayName) {
            this.schema = hostId.getSchema();
            this.displayName = displayName;
            this.punycodeHostname = hostId.getPunycodeHostname();
            this.webmasterHostId = hostId;
        }

        public WebmasterHostId.Schema getSchema() {
            return schema;
        }

        public String getDisplayName() {
            return displayName;
        }

        public String getPunycodeHostname() {
            return punycodeHostname;
        }

        public WebmasterHostId getWebmasterHostId() {
            return webmasterHostId;
        }
    }
}
