package ru.yandex.webmaster3.viewer.http.user;

import java.util.List;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.user.dao.DashboardSurveyAnswersYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

/**
 * ishalaru
 * 23.12.2020
 **/
@WriteAction
@Category("user")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Component("/user/useCases/save")
public class UserSaveUseCasesAction extends AbstractUserAction<UserSaveUseCasesAction.Request, UserSaveUseCasesAction.Response> {
    private final DashboardSurveyAnswersYDao dashboardSurveyAnswersYDao;

    @Override
    public UserSaveUseCasesAction.Response process(UserSaveUseCasesAction.Request request) {
        dashboardSurveyAnswersYDao.add(request.getUserId(),
                request.getHostId(),
                request.getSurveyType(),
                request.getAnswerPlace(),
                request.getSelectedCases());
        return new Response();
    }

    @Getter
    @Setter(onMethod_ = @RequestQueryProperty(required = true))
    public static class Request extends AbstractUserRequest {
        @Description("Список идентификаторов которые были выбраны")
        private List<String> selectedCases;
        @Description("Откуда пришел ответ(Дашборд, страница)")
        private String answerPlace;
        @Description("Тип опроса")
        private String surveyType;
        @Description("хост")
        @Setter(onMethod_ = @RequestQueryProperty)
        private WebmasterHostId hostId;
    }

    public static class Response implements ActionResponse.NormalResponse {

    }
}
