package ru.yandex.webmaster3.viewer.http.user.settings.dashboard;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;
import ru.yandex.webmaster3.viewer.http.user.settings.notification2.GetUserNotification2SettingsAction;
import ru.yandex.webmaster3.viewer.http.user.settings.notification2.GetUserNotification2SettingsRequest;
import ru.yandex.webmaster3.viewer.http.user.settings.notification2.GetUserNotification2SettingsResponse;

/**
 * Тут будет кэшироование
 * @author avhaliullin
 */
@ReadAction
@Category("user")
@Description("Быстрая (возможно, кэширующая) ручка для дашборда, возвращающая настройки уведомлений для пользователя")
public class GetDashboardUserNotificationSettingsAction extends AbstractUserAction<GetUserNotification2SettingsRequest, GetUserNotification2SettingsResponse> {
    private GetUserNotification2SettingsAction delegate;

    @Override
    public GetUserNotification2SettingsResponse process(GetUserNotification2SettingsRequest request) {
        return delegate.process(request);
    }

    @Required
    public void setDelegate(GetUserNotification2SettingsAction delegate) {
        this.delegate = delegate;
    }
}
