package ru.yandex.webmaster3.viewer.http.user.settings.frontend;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.user.settings.FrontendUserSettingsKey;
import ru.yandex.webmaster3.storage.user.settings.FrontendUserSettingsYDao;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;

import java.util.Collections;
import java.util.Map;

/**
 * @author avhaliullin
 */
@ReadAction
@Category("user")
@Description("Посмотреть значения настроек для пачки ключей")
@Component("/user/settings/multipleRead")
public class GetMultipleUserSettingsAction extends Action<GetMultipleUserSettingsRequest, GetMultipleUserSettingsResponse> {
    private final FrontendUserSettingsYDao frontendUserSettingsYDao;

    @Autowired
    public GetMultipleUserSettingsAction(FrontendUserSettingsYDao frontendUserSettingsYDao) {
        this.frontendUserSettingsYDao = frontendUserSettingsYDao;
    }

    @Override
    public GetMultipleUserSettingsResponse process(GetMultipleUserSettingsRequest request) throws WebmasterException {
        if (CollectionUtils.isEmpty(request.getKeys())) {
            return new GetMultipleUserSettingsResponse(Collections.emptyMap());
        }
        try {
            Map<FrontendUserSettingsKey, String> settings = frontendUserSettingsYDao.getValues(request.getUserId(), request.getKeys());
            request.getKeys().forEach(key -> settings.putIfAbsent(key, null)); // чтобы явно показать поле с null'ом
            return new GetMultipleUserSettingsResponse(settings);
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Failed to get user settings",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }
}
