package ru.yandex.webmaster3.viewer.http.user.settings.frontend;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.user.settings.FrontendUserHostSettingsYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author avhaliullin
 */
@ReadAction
@Category("user")
@Description("Посмотреть настройки пользователя для хоста")
public class GetUserHostSettingsAction extends AbstractUserVerifiedHostAction<GetUserHostSettingsRequest, GetUserHostSettingsResponse> {
    private FrontendUserHostSettingsYDao frontendUserHostSettingsYDao;

    @Override
    public GetUserHostSettingsResponse process(GetUserHostSettingsRequest request) {
        try {
            String value = frontendUserHostSettingsYDao.getValue(
                    request.getUserId(),
                    request.getHostId(),
                    request.getKey()
            );
            return new GetUserHostSettingsResponse(value);
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Failed to get user host settings",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }

    @Required
    public void setFrontendUserHostSettingsYDao(FrontendUserHostSettingsYDao frontendUserHostSettingsYDao) {
        this.frontendUserHostSettingsYDao = frontendUserHostSettingsYDao;
    }
}
